
// This extension is designed to get installed with the .NET Framework by a registry setting in HKLM.  The first time Firefox starts
// after this is installed it will pick up the extension and start to use it.  The extension then looks for the MicrosoftDotNetFrameworkAssistant.xpi
// in the same directory and installs it into the Firefox profile.  Since the extension that is installed in the user profile shares
// the same ID this extension is masked and will not be loaded again.  If the user uninstalls the copy in their profile this will 
// re-activate, check the auto_install flag, and not re-install the user extension.  It will also make sure that the user agent additions
// made by the other version of the extension are cleared.

// Why does it work this way?
// Extensions installed to privileged locations don't respect the <updateURL> property in the install.rdf.  This is probably because
// without elevation of permissions they cannot update the extension in place.  The only other option would be to advertise compatibility
// with version of Firefox that we have not tested and hope that if the extension breaks that we can find a way to get an update out.

BootStrapDotNetAsssitantExtension();

function BootStrapDotNetAsssitantExtension()
{
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefService)
                        .getBranch("microsoft.CLR.");

    // When the XPI is installed it will hide this extension so the only time this condition
    // is false will be when the user has *uninstalled* the user mode extension.  Since it
    // would be rude to automatically re-install we save this to indicate that we're not wanted.
    var auto_install = prefs.getBoolPref("auto_install");
    
    if (auto_install)
    {
        // This extension shares an ID with the one it is bootstraping.  This makes the extension installed
        // into the user profile an update of this extension.
        var id = "{20a82645-c095-46ed-80e3-08825760534b}";
        
        var extensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
                                    .getService(Components.interfaces.nsIExtensionManager);

        // this is an nsIFile
        var xpiLocation = extensionManager.getInstallLocation(id).getItemFile(id, "MicrosoftDotNetFrameworkAssistant.xpi");
       
        // If we fail in some spectacular way we want to make sure that the user
        // doesn't have to see the error every time they start the browser.
        prefs.setBoolPref("auto_install", false);
    
        extensionManager.installItemFromFile(xpiLocation, "app-profile");
    }
    else
    {
        // Clear user agent on uninstall
        var useragentExtrasPref = Components.classes["@mozilla.org/preferences-service;1"]
                                    .getService(Components.interfaces.nsIPrefService)
                                    .getBranch("general.useragent.extra.");

        useragentExtrasPref.clearUserPref("microsoftdotnet");
    }
}
